
  import javafx.application.Application;
  import javafx.scene.Scene;
  import javafx.scene.layout.Pane;
  import javafx.scene.paint.Color;
  import javafx.stage.Stage;
  import javafx.scene.input.MouseEvent;
  import javafx.scene.input.MouseButton;
  public class Animation2 extends Application 
  {
     private SnowManCanvas sm1;
     double deltaX, deltaY;
     boolean sm1Clicked = false;

     public void start(Stage primaryStage) 
     {
        
        sm1 = new SnowManCanvas(280, 40, Color.BLUE);

        Pane root = new Pane();
        
        root.getChildren().addAll(sm1.getCanvas());
                
        Scene scene = new Scene(root, 600, 300, Color.LIGHTGRAY);
        scene.setOnMouseClicked((e) -> mouseClickedHandler(e)); 
        scene.setOnMouseDragged((e) -> mouseDraggedHandler(e)); 

        primaryStage.setTitle("Drawing On a Canvas");
        primaryStage.setScene(scene);
        primaryStage.show();
     }

     public void mouseClickedHandler(MouseEvent e)
     {
        if((e.getButton() == MouseButton.PRIMARY)) //a left click
        {
           if(e.getX() > sm1.getX() + sm1.getCanvas().getTranslateX() && 
              e.getX() < sm1.getX() + sm1.getCanvas().getTranslateX() + 40 &&
              e.getY() > sm1.getY() + sm1.getCanvas().getTranslateY() && 
              e.getY() < sm1.getY() + sm1.getCanvas().getTranslateY() + 90)
           { //the click was on the canvas
              deltaX =  e.getX() - sm1.getCanvas().getTranslateX();
              deltaY =  e.getY() - sm1.getCanvas().getTranslateY();
              sm1Clicked = true; 
           }
           else //the click was not on the canvas
           {
              sm1Clicked = false;
           }
        }
     }  
    
     public void mouseDraggedHandler(MouseEvent e)
     {
        if(sm1Clicked == true && e.getButton() == MouseButton.PRIMARY)
        {    
          sm1.getCanvas().setTranslateX(e.getX() - deltaX);
          sm1.getCanvas().setTranslateY(e.getY() - deltaY);
        }
     }

     public static void main(String[] args) 
     {
        launch(args);
     }
  }

